unit DemoMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, FileCtrl, ShellAPI, DB, RTFRep,
  DBF;

type
  TRTFGenForm = class(TForm)
    DstDlg: TSaveDialog;
    NB: TNotebook;
    Label4: TLabel;
    lbIntro: TLabel;
    Label1: TLabel;
    Bevel2: TBevel;
    Bevel4: TBevel;
    Bevel7: TBevel;
    btnNext0: TButton;
    btnCancel0: TButton;
    SrcFileName: TComboBox;
    Label3: TLabel;
    Bevel5: TBevel;
    Bevel1: TBevel;
    AVI: TAnimate;
    Progress: TProgressBar;
    Status: TPanel;
    Log: TMemo;
    btnNext1: TButton;
    btnCancel1: TButton;
    Label5: TLabel;
    lbFinal: TLabel;
    Bevel3: TBevel;
    Bevel6: TBevel;
    btnCancel2: TButton;
    Generator: TRTFReport;
    btnSaveReport: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnNext0Click(Sender: TObject);
    procedure btnNext1Click(Sender: TObject);
    procedure btnCancel0Click(Sender: TObject);
    procedure btnCancel1Click(Sender: TObject);
    procedure GeneratorFinish(Sender: TObject);
    procedure btnSaveReportClick(Sender: TObject);
    function GeneratorTag(Sender: TObject; FunctionName: String;
      const Args: TArgList; const ArgCnt: Integer): Variant;
    procedure GeneratorGetTable(Sender: TObject; TableName: String;
      var DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
    Report  : String;
  end;
Var
  RTFGenForm : TRTFGenForm;

implementation
{$R *.DFM}

procedure TRTFGenForm.FormCreate(Sender: TObject);
Var
  SR : TSearchRec;
  s  : String;
  r  : Integer;
begin
  r:=FindFirst(ExtractFilePath(ParamStr(0))+'Tpl\'+'*.rtf',faArchive,SR);
  While r=0 do
    begin
      s:=SR.Name; SetLength(s,Length(s)-4);
      SrcFileName.Items.Add(s);
      r:=FindNext(SR);
    end;
  FindClose(SR);
  If SrcFileName.Items.Count>0 then SrcFileName.ItemIndex:=0;

  lbIntro.Caption:=
    '     This project is designed to demonstrate using of '+
    'RTFReport component for Delphi.'#13+
    '     RTFReport creates Rich Text Format documents by merging RTF template and '+
    'data. To design template you may use almost any RTF-enabled editor such as '+
    'Microsoft Word).'#13+
    '     This demo searches for templates in '+
    '"'+ExtractFilePath(ParamStr(0))+'Tpl\'+'" folder.';
  NB.PageIndex:=0;
end;

procedure TRTFGenForm.btnNext0Click(Sender: TObject);
Var
   F : TFileStream;
   fn : String;
   a : Integer;
begin
  fn:=ExtractFilePath(ParamStr(0))+'Tpl\'+SrcFileName.Text+'.rtf';
try
  F:=TFileStream.Create( fn, fmOpenRead or fmShareDenyNone);
  F.Read(a,SizeOf(a));
  F.Free;
  Log.Lines.Clear;
  btnNext1.Enabled:=False;
  AVI.Visible:=True;
  AVI.ResName:='BOOKS_AVI';
  AVI.Active:=True;
  NB.PageIndex:=1;
  Log.Lines.Add('Loading data...');
  Generator.LoadTemplate( fn );
  Report:=Generator.Execute;
except
  MessageDlg('Error while opening file '+fn, mtError,[mbCancel],0);
end;
end;

procedure TRTFGenForm.btnNext1Click(Sender: TObject);
begin
  lbFinal.Caption:=
    '    You may view, print or edit this report using with any RTF-enabled editor.'+
    ''#13+
    '    Unfortunately WordPad that is part of Windows9X is not full-featured '+
    'RTF editor. It supports no tables or images for example. So you will be unable to use all '+
    'TRTFReport capabilities with WorfPad';
    NB.PageIndex:=2;
end;

procedure TRTFGenForm.btnCancel0Click(Sender: TObject);
begin
  Close;
end;

procedure TRTFGenForm.btnCancel1Click(Sender: TObject);
begin
  If btnNext1.Enabled
    then Close
    else Generator.Terminated:=False;
end;

procedure TRTFGenForm.GeneratorFinish(Sender: TObject);
begin
  AVI.Visible:=False;
  AVI.Active:=False;
  Status.Caption:='';
  Progress.Position:=0;
  Log.Lines.Add('Generation complete');
  btnNext1.Enabled:=(Not Generator.Terminated);
  btnCancel1.Caption:='Close';
end;

procedure TRTFGenForm.btnSaveReportClick(Sender: TObject);
Var
   F : File;
   s : String;
begin
  If Not DstDlg.Execute then Exit;
  s:=DstDlg.FileName;
  {$I-}
  AssignFile(F,s); ReWrite(F,1);
  BlockWrite(F,Report[1], Length(Report));
  CloseFile(F);
  If IOResult<>0 then
    begin
      MessageDlg('Error while saving file. ',mtError,[mbCancel],0);
      Exit;
    end;
  s:=s+#0;
  If MessageDlg('Would you like to load report in external editor ?',
      mtConfirmation,[mbYes,mbNo],0)=mrYes then
    ShellExecute(Handle, Nil, PChar(@s[1]), Nil, Nil, SW_SHOWDEFAULT);
end;

function TRTFGenForm.GeneratorTag(Sender: TObject; FunctionName: String;
  const Args: TArgList; const ArgCnt: Integer): Variant;
Var
    t1,t2     : TPoint;
    r         : TRect;
    b,b1      : TBitMap;
    d         : TDataSet;
begin
  Result:='';
  If Generator.Terminated then Exit;
  If (FunctionName='progressmax') then
    begin
      try
        Progress.Position:=0;
        Progress.Max:=Args[0];
      except
        Progress.Max:=100;
      end;
    end else
  If (FunctionName='showprogress') then
    begin
      Status.Caption:=VarToStr(Args[0]);
      Progress.Position:=Progress.Position+1;
    end else
  If (FunctionName='log') then
    begin
      try
        Log.Lines.Add(Args[0])
      except
      end;
    end else
  If (FunctionName='animalphoto') then
    begin
      b:=TBitMap.Create;
      b1:=TBitMap.Create;
      d:=Generator.GetTable('Animals').DataSet;
      If d<>Nil then
        begin
          b1.Assign( d.FieldByName('BMP') );
          b.Width:=b1.Width; b.Height:=b1.Height;
          b.Canvas.Draw(0,0,b1);
          t1.X:=b1.Width; t1.Y:=b1.Width;
          t2.X:=50;  t2.Y:=50;
          FillChar(r,SizeOf(r),0);
          Generator.InsertBitmap(b,t1,t2,r,pbNone,20,1,pshNone,0,0,0);
          b.Free;
          b1.Free;
        end;
    end else
    begin
      Generator.SetError('Undefined function '+FunctionName+' !');
    end;
end;

procedure TRTFGenForm.GeneratorGetTable(Sender: TObject; TableName: String;
  var DataSet: TDataSet);
begin
  DataSet:=TDBF.Create(Nil);
  TDBF(DataSet).ReadOnly:=True;
  TDBF(DataSet).TableName:=ExtractFilePath(ParamStr(0))+'DB\'+TableName+'.dbf';
end;

end.
